<?php
require_once __DIR__.'/config.php';
require_login();

$me = current_user($pdo);
$firstLetter = mb_strtoupper(mb_substr($me['nome'],0,1));

/* Carrega config do FideSlot */
$cfgStmt = $pdo->query("SELECT lock_hours, logo_src, spin_cost FROM slot_config WHERE id=1");
$cfg = $cfgStmt->fetch();

$slotLockHours = $cfg ? (int)$cfg['lock_hours'] : 24;
$slotLogo      = $cfg ? $cfg['logo_src']        : 'assets/img/slot.png';
$slotCost      = $cfg ? (int)$cfg['spin_cost']  : 0;

/* calcula cooldown específico do slot */
$nextFreeAtMs = 0;
if (!empty($me['ultimo_slot'])) {
    $ultimo = strtotime($me['ultimo_slot']);       // último giro no slot (segundos)
    $next   = $ultimo + ($slotLockHours * 3600);    // libera em X horas
    $nextFreeAtMs = $next * 1000;                   // JS usa ms
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width,initial-scale=1" />
<title>FideSlot — Gamefid</title>
<meta name="color-scheme" content="dark" />
<style>
:root{
  --bg:#0b1220; --panel:#0e1729dd; --border:#1c2a44; --muted:#9aa4b2; --ink:#eaf0ff;
  --gold:#ffd54d; --gold2:#ffe082;
}
*{box-sizing:border-box}
html,body{
  margin:0;height:100%;
  background:
    radial-gradient(1400px 900px at 50% -20%, #10275a 0%, #0a1222 45%),
    radial-gradient(1000px 700px at 50% 120%, #0b1f4a 0%, #0a1222 60%);
  color:var(--ink);font-family:Inter,ui-sans-serif,system-ui;
}

/* ===== TOP MENU ===== */
.topbar{
  position:sticky;top:0;z-index:50;
  background:var(--panel);
  border-bottom:1px solid var(--border);
  backdrop-filter:blur(18px) saturate(150%);
  box-shadow:0 24px 80px #000a;
}
.top-inner{
  max-width:480px;margin:0 auto;
  padding:12px 16px;
  display:flex;align-items:center;justify-content:space-between;gap:10px;
}
.userbox{
  display:flex;align-items:center;gap:10px;min-width:0;
}
.avatar{
  width:36px;height:36px;border-radius:12px;
  background:radial-gradient(circle at 30% 30%,#7c3aed 0%,#0ea5e9 60%);
  color:#fff;font-weight:700;font-size:14px;
  display:grid;place-items:center;
  box-shadow:0 18px 40px #000a;
  flex-shrink:0;
}
.userinfo{
  font-size:12px;line-height:1.3;color:#fff;min-width:0;
}
.userinfo .name{
  font-weight:600;font-size:13px;color:#fff;
  max-width:160px;
  white-space:nowrap;text-overflow:ellipsis;overflow:hidden;
  display:block;
}
.userinfo .pts{color:var(--gold);font-weight:700;white-space:nowrap;}
.menu-wrapper{position:relative;}
.menu-btn{
  appearance:none;
  background:#0b142b;border:1px solid #243357;border-radius:10px;
  color:#e5e7eb;
  padding:8px 10px;
  display:flex;align-items:center;justify-content:center;
  min-width:40px;min-height:36px;
  box-shadow:0 16px 40px #000a;
  cursor:pointer;
}
.menu-btn:active{transform:scale(.97);}
.menu-icon svg{
  width:20px;height:20px;fill:#e5e7eb;
}
.dropdown{
  position:absolute;
  right:0;
  top:calc(100% + 8px);
  min-width:180px;
  background:#0e1729;
  border:1px solid var(--border);
  border-radius:14px;
  box-shadow:0 24px 80px #000a;
  padding:8px 0;
  display:none;
  z-index:60;
}
.dropdown.open{display:block;}
.drop-head{
  padding:10px 14px 12px;
  border-bottom:1px solid var(--border);
  display:flex;
  flex-direction:column;
  gap:4px;
  font-size:13px;
  color:#fff;
}
.drop-name{
  font-weight:600;
  color:#fff;
  line-height:1.3;
  word-break:break-word;
}
.drop-pts{
  font-size:12px;
  color:var(--gold);
  font-weight:700;
}
.drop-link{
  width:100%;
  display:flex;
  align-items:center;
  gap:8px;
  padding:12px 14px;
  background:transparent;
  border:0;
  text-align:left;
  color:#e5e7eb;
  font-size:13px;
  line-height:1.2;
  cursor:pointer;
  text-decoration:none;
}
.drop-link:hover,
.drop-link:focus{background:#0b142b;outline:0;}
.drop-link.danger{color:#ffd2d2;}
.drop-ico{
  width:16px;height:16px;flex-shrink:0;
  color:currentColor;display:grid;place-items:center;
}
.drop-ico svg{
  width:100%;height:100%;
  fill:currentColor;
}

/* ===== PAGE BODY ===== */
.wrap{
  max-width:480px;
  margin:0 auto;
  padding:14px 12px 80px;
  min-height:100dvh;
  display:grid;
  gap:14px;
}
.top{
  display:grid;
  place-items:center;
  gap:10px;
  text-align:center;
}
.logoBox{
  width:100%;
  display:flex;
  align-items:center;
  justify-content:center;
  padding:8px 0;
}
.logoBox img{
  max-width:100%;
  width:100%;
  height:auto;
  max-height:220px;
  object-fit:contain;
  filter:drop-shadow(0 8px 22px #0009);
}
.gameTitle{
  font-size:16px;
  font-weight:700;
  margin:0;
  color:#fff;
}
.subtitle{
  margin:0;
  color:#cdd6e3;
  font-size:13px;
}
.timer{
  display:flex;align-items:center;justify-content:center;
  gap:10px;
  font-weight:900;
  font-size:clamp(20px,6.5vw,30px);
  font-variant-numeric:tabular-nums;
}
.timer .fire{
  width:24px;height:24px;
  display:grid;place-items:center;
  border-radius:9px;
  background:radial-gradient(60% 80% at 30% 20%, #ff9f1c, #ff5f1e 60%);
  box-shadow:0 6px 20px #ff6a0033;
}
.hint{
  margin:-4px 0 6px;
  text-align:center;
  color:#9fb0d4;
  font-size:12px;
}
.statusline{
  font-size:13px;
  color:#9fb0d4;
  min-height:16px;
  text-align:center;
}

/* ===== SLOT MACHINE ===== */
.slot-stage{
  background:radial-gradient(circle at 50% 0%,#1e293b55,#0000 60%);
  width:100%;
  max-width:360px;
  margin:0 auto;
  border:1px solid #1c2a44;
  border-radius:16px;
  background-color:#0e1729dd;
  box-shadow:0 30px 80px #000a;
  padding:16px;
  display:grid;
  gap:12px;
  text-align:center;
}
.reels-frame{
  border:2px solid #243357;
  border-radius:12px;
  background:#0b142b;
  box-shadow:
    0 12px 30px #000a,
    inset 0 0 20px #000;
  padding:12px;
  display:grid;
  grid-template-columns:repeat(3,1fr);
  gap:12px;
  min-height:100px;
}
.reel{
  background:#0e1729;
  border:1px solid #1c2a44;
  border-radius:10px;
  box-shadow:0 10px 30px #000c,inset 0 0 30px #000d;
  font-size:40px;
  font-weight:700;
  color:#fff;
  height:74px;
  display:flex;
  align-items:center;
  justify-content:center;
  position:relative;
  overflow:hidden;
}
.reel-inner{
  position:absolute;
  left:0;right:0;
  top:0;
  display:flex;
  flex-direction:column;
  align-items:center;
  justify-content:flex-start;
  font-size:40px;
  font-weight:700;
  transition:transform 0.6s cubic-bezier(.16,1,.3,1);
  will-change:transform;
  color:#fff;
}
.spin-btn-wrap{
  display:grid;
  place-items:center;
}
#spinBtn{
  appearance:none;
  border:0;
  border-radius:999px;
  width:100px;
  height:100px;
  background:radial-gradient(120px 120px at 30% 30%, var(--gold2), var(--gold) 60%);
  color:#0a1222;
  font-weight:900;
  font-size:18px;
  box-shadow:0 14px 40px #000a,inset 0 8px 18px #ffffff55;
  cursor:pointer;
}
#spinBtn:active{transform:scale(.98);}
#spinBtn[disabled]{filter:grayscale(.45);opacity:.6;cursor:not-allowed;}

#status{
  color:#9fb0d4;
  font-size:12px;
  min-height:18px;
  text-align:center;
}

.footer{
  font-size:12px;
  color:#9aa4b2;
  text-align:center;
  margin-top:20px;
}

/* ===== MODAL RESULTADO ===== */
.modal{
  position:fixed;
  inset:0;
  z-index:60;
  display:none;
  place-items:center;
  background:#0008;
}
.modal-box{
  width:min(420px,92vw);
  background:var(--panel);
  border:1px solid var(--border);
  border-radius:16px;
  box-shadow:0 32px 100px #000a;
  color:#fff;
}
.modal-hd{
  padding:12px 16px;
  border-bottom:1px solid var(--border);
  display:flex;
  align-items:center;
  justify-content:space-between;
  font-size:14px;
  font-weight:600;
  color:#fff;
}
.modal-close{
  background:transparent;
  border:1px solid var(--border);
  color:#cbd5e1;
  border-radius:10px;
  padding:6px 10px;
  cursor:pointer;
  font-size:13px;
}
.modal-bd{
  padding:18px 16px;
  color:#cbd5e1;
  font-size:14px;
}
.modal-bd h2{
  margin:0 0 12px;
  font-size:24px;
  line-height:1.15;
  font-weight:700;
  color:#fff;
}
.badgeColor{
  width:14px;
  height:14px;
  border-radius:999px;
  box-shadow:0 0 0 2px #0b1220,0 0 0 3px #1c2a4d;
}
</style>
</head>
<body>

<header class="topbar">
  <div class="top-inner">
    <!-- usuário -->
    <div class="userbox">
      <div class="avatar"><?php echo htmlspecialchars($firstLetter); ?></div>
      <div class="userinfo">
        <div class="name"><?php echo htmlspecialchars($me['nome']); ?></div>
        <div class="pts"><span id="saldo"><?php echo fmt_pts($me['pontos_total']); ?></span> pts</div>
      </div>
    </div>

    <!-- hambúrguer -->
    <div class="menu-wrapper">
      <button id="menuBtn" class="menu-btn" aria-label="menu">
        <span class="menu-icon">
          <svg viewBox="0 0 24 24">
            <rect x="3" y="6"  width="18" height="2" rx="1"/>
            <rect x="3" y="11" width="18" height="2" rx="1"/>
            <rect x="3" y="16" width="18" height="2" rx="1"/>
          </svg>
        </span>
      </button>

      <div id="menuDrop" class="dropdown" aria-hidden="true">
        <div class="drop-head">
          <div class="drop-name"><?php echo htmlspecialchars($me['nome']); ?></div>
          <div class="drop-pts"><?php echo fmt_pts($me['pontos_total']); ?> pts</div>
        </div>

        <a class="drop-link" href="ranking.php">
          <span class="drop-ico"><svg viewBox="0 0 24 24"><path d="M7 21v-8H3v8h4Zm7 0V3h-4v18h4Zm7 0v-12h-4v12h4Z"/></svg></span>
          <span>Ranking</span>
        </a>

        <?php if(is_admin()): ?>
        <a class="drop-link" href="slot_admin/">
          <span class="drop-ico"><svg viewBox="0 0 24 24"><path d="M12 2 2 7l10 5 10-5-10-5Zm0 9.75L2 7v10l10 4.75L22 17V7l-10 4.75Z"/></svg></span>
          <span>Admin Slot</span>
        </a>
        <?php endif; ?>

        <a class="drop-link danger" href="logout.php">
          <span class="drop-ico"><svg viewBox="0 0 24 24"><path d="M10 3H5v18h5v-2H7V5h3V3Zm4.59 4.59L13.17 9l2.59 2.59L12 15.34l1.41 1.41L18.17 12l-4.58-4.59Z"/></svg></span>
          <span>Sair</span>
        </a>
      </div>
    </div>
  </div>
</header>

<div class="wrap">

  <div class="top">
    <div class="logoBox">
      <img id="logo" src="<?php echo htmlspecialchars($slotLogo); ?>" alt="FideSlot">
    </div>

    <p class="gameTitle">FideSlot 🎰</p>
    <p class="subtitle">Gire os rolos, combine 3 e ganhe pontos 😎</p>

    <div class="timer">
      <span class="fire" aria-hidden="true">🔥</span>
      <span id="countdown">--:--:--</span>
    </div>

    <div id="hint" class="hint">
      1 giro disponível a cada <?php echo (int)$slotLockHours; ?> horas
      <?php if ($slotCost > 0): ?>
      • Custo: <?php echo (int)$slotCost; ?> pts
      <?php endif; ?>
    </div>

    <div class="statusline" id="statusTop"></div>
  </div>

  <section class="slot-stage">
    <div class="reels-frame">
      <div class="reel"><div class="reel-inner" id="reel0"><div>❔</div></div></div>
      <div class="reel"><div class="reel-inner" id="reel1"><div>❔</div></div></div>
      <div class="reel"><div class="reel-inner" id="reel2"><div>❔</div></div></div>
    </div>

    <div class="spin-btn-wrap">
      <button id="spinBtn">GIRAR</button>
    </div>

    <div id="status" style="min-height:18px;color:#9fb0d4;font-size:12px;text-align:center;"></div>
  </section>

  <div class="footer">
    Desenvolvido por <strong>Dia Studio</strong>
  </div>

</div>

<!-- MODAL RESULTADO -->
<div id="resultModal" class="modal" aria-hidden="true">
  <div class="modal-box">
    <div class="modal-hd">
      <span>Resultado</span>
      <button class="modal-close" id="modalClose">Fechar</button>
    </div>
    <div class="modal-bd">
      <p style="margin:0 0 8px">Combinação:</p>
      <h2 id="modalCombo">---</h2>
      <div style="display:flex;align-items:center;gap:10px;margin-bottom:12px">
        <span id="modalColor" class="badgeColor" style="background:#fff"></span>
        <small style="color:#9aa4b2">Símbolo</small>
      </div>
      <div style="font-size:13px;color:#9aa4b2" id="modalPoints">+0 pts adicionados à sua conta</div>
    </div>
  </div>
</div>

<script>
// ===== MENU HAMBURGUER =====
const menuBtn   = document.getElementById('menuBtn');
const menuDrop  = document.getElementById('menuDrop');
function closeMenu(){
  menuDrop.classList.remove('open');
  menuDrop.setAttribute('aria-hidden','true');
}
function openMenu(){
  menuDrop.classList.add('open');
  menuDrop.setAttribute('aria-hidden','false');
}
menuBtn.addEventListener('click',function(e){
  e.stopPropagation();
  if(menuDrop.classList.contains('open')){ closeMenu(); } else { openMenu(); }
});
document.addEventListener('click',function(e){
  if(!menuDrop.contains(e.target) && !menuBtn.contains(e.target)){
    closeMenu();
  }
});

// ===== VARIÁVEIS DO SERVIDOR =====
let initialNextFreeAt = <?php echo $nextFreeAtMs ? $nextFreeAtMs : '0'; ?>;
let lockHours         = <?php echo (int)$slotLockHours; ?>;

const saldoEl     = document.getElementById('saldo');
const statusEl    = document.getElementById('status');
const statusTop   = document.getElementById('statusTop');
const countdownEl = document.getElementById('countdown');

const btnSpin     = document.getElementById('spinBtn');

const reelEls = [
  document.getElementById('reel0'),
  document.getElementById('reel1'),
  document.getElementById('reel2'),
];

const modal        = document.getElementById('resultModal');
const modalClose   = document.getElementById('modalClose');
const modalCombo   = document.getElementById('modalCombo');
const modalColor   = document.getElementById('modalColor');
const modalPoints  = document.getElementById('modalPoints');

let spinning = false;

// som
const ac = new (window.AudioContext||window.webkitAudioContext)();
function tickSound(){
  const o=ac.createOscillator(),g=ac.createGain();
  o.type='square';o.frequency.value=1200;
  g.gain.value=0.04;o.connect(g);g.connect(ac.destination);
  o.start();o.stop(ac.currentTime+0.05);
}

// modal
function openModal(infoStr, color, pts){
  modalCombo.textContent = infoStr;
  modalColor.style.background = color || '#ffffff';
  modalPoints.textContent = "+"+pts+" pts adicionados à sua conta";
  modal.style.display='grid';
}
function closeModalBox(){ modal.style.display='none'; }
modalClose.addEventListener('click',closeModalBox);
modal.addEventListener('click',function(e){ if(e.target===modal) closeModalBox(); });

// cooldown
function updateCountdownLoop(){
  if(!initialNextFreeAt || initialNextFreeAt < Date.now()){
    countdownEl.textContent="00:00:00";
    btnSpin.disabled=false;
    statusTop.textContent="";
    return;
  }
  const diff = initialNextFreeAt - Date.now();
  const total = Math.max(0,Math.floor(diff/1000));
  const h = Math.floor(total/3600);
  const m = Math.floor((total%3600)/60);
  const s = total%60;

  countdownEl.textContent =
    String(h).padStart(2,'0')+":"+
    String(m).padStart(2,'0')+":"+
    String(s).padStart(2,'0');

  btnSpin.disabled = true;
  statusTop.textContent = "Bloqueado. Falta " + countdownEl.textContent;
}
setInterval(updateCountdownLoop,1000);

// servidor mandou "HH:MM:SS" quando bloqueado
function syncFromRemaining(hms){
  const parts = hms.split(':').map(function(v){return parseInt(v,10)||0;});
  const h=parts[0]||0;
  const m=parts[1]||0;
  const s=parts[2]||0;
  const addMs = ((h*3600)+(m*60)+s)*1000;
  initialNextFreeAt = Date.now() + addMs;
}

// anima os 3 rolos
function animateReels(symbols){
  // symbols é tipo ["🍒","🍒","💎"]
  for (let idx=0; idx<3; idx++){
    const reelInner = reelEls[idx];
    let tempHTML = '';
    for(let i=0;i<5;i++){
      tempHTML += '<div style="height:74px;display:flex;align-items:center;justify-content:center;">❓</div>';
    }
    tempHTML += '<div style="height:74px;display:flex;align-items:center;justify-content:center;font-size:40px;">'+symbols[idx]+'</div>';
    reelInner.innerHTML = tempHTML;
    reelInner.style.transform = 'translateY(0px)';
  }

  void reelEls[0].offsetHeight; // força repaint

  for (let idx=0; idx<3; idx++){
    const reelInner = reelEls[idx];
    const delayMs = idx * 200;
    setTimeout(function(){
      try{ac.resume&&ac.resume();}catch(e){}
      tickSound();
      reelInner.style.transform = 'translateY(-370px)'; // 5*74
    }, delayMs);
  }
}

// girar
function spinSlot(){
  if(spinning) return;
  spinning = true;
  btnSpin.disabled = true;
  statusEl.textContent = 'Girando...';

  fetch('spin_slot.php', { method:'POST' })
    .then(function(r){return r.json();})
    .then(function(data){
      if(data.error === 'locked'){
        statusEl.textContent = 'Aguarde o próximo giro';
        statusTop.textContent = 'Bloqueado. Falta ' + data.remaining;
        spinning = false;
        btnSpin.disabled = true;
        syncFromRemaining(data.remaining);
        return;
      }

      if(!data.ok){
        statusEl.textContent = data.msg || 'Erro ao girar';
        spinning = false;
        btnSpin.disabled = false;
        return;
      }

      // roda visualmente
      animateReels(data.reels);

      setTimeout(function(){
        spinning = false;

        saldoEl.textContent = new Intl.NumberFormat('pt-BR').format(data.new_total);

        if(data.win){
          statusEl.textContent = 'Você ganhou +' + data.added_points + ' pts (' + data.symbol.label + ')';
          statusTop.textContent = 'Resultado: ' + data.reels.join(' ');
        } else {
          statusEl.textContent = 'Não teve combinação 😕';
          statusTop.textContent = 'Resultado: ' + data.reels.join(' ');
        }

        openModal(
          data.reels.join('  '),
          data.symbol ? data.symbol.color : '#ffffff',
          data.added_points
        );

        // trava o cooldown para o próximo giro
        if (data.next_free_at){
          initialNextFreeAt = data.next_free_at;
        } else {
          initialNextFreeAt = Date.now() + (lockHours*60*60*1000);
        }

      }, 1200);
    })
    .catch(function(){
      statusEl.textContent = 'Erro de rede';
      spinning = false;
      btnSpin.disabled = false;
    });
}

function init(){
  updateCountdownLoop();
}

window.addEventListener('load', init);
btnSpin.addEventListener('click', function(){
  try{ac.resume&&ac.resume();}catch(e){}
  spinSlot();
});
</script>
</body>
</html>
