<?php
require_once __DIR__.'/../config.php';
require_login();
require_admin();

$lock_hours = isset($_POST['lock_hours']) ? (int)$_POST['lock_hours'] : 24;
$logo_src   = isset($_POST['logo_src'])   ? trim($_POST['logo_src']) : 'assets/img/slot.png';
$spin_cost  = isset($_POST['spin_cost'])  ? (int)$_POST['spin_cost'] : 0;

if ($lock_hours < 1) $lock_hours = 1;
if ($spin_cost < 0) $spin_cost = 0;

$stmt = $pdo->prepare("
    INSERT INTO slot_config (id, lock_hours, logo_src, spin_cost)
    VALUES (1,?,?,?)
    ON DUPLICATE KEY UPDATE
      lock_hours = VALUES(lock_hours),
      logo_src   = VALUES(logo_src),
      spin_cost  = VALUES(spin_cost)
");
$stmt->execute([$lock_hours,$logo_src,$spin_cost]);

header("Location: index.php");
exit;
