<?php
require_once __DIR__.'/../config.php';
require_login();
require_admin();

$id             = isset($_POST['id']) ? (int)$_POST['id'] : 0;
$emoji          = isset($_POST['emoji']) ? trim($_POST['emoji']) : '';
$label          = isset($_POST['label']) ? trim($_POST['label']) : '';
$color          = isset($_POST['color']) ? trim($_POST['color']) : '#ffffff';
$weight         = isset($_POST['weight']) ? (float)$_POST['weight'] : 1;
$reward_points  = isset($_POST['reward_points']) ? (int)$_POST['reward_points'] : 0;

if ($weight < 0) $weight = 0;
if ($reward_points < 0) $reward_points = 0;

if ($id > 0) {
    // update existente
    $stmt = $pdo->prepare("
        UPDATE slot_symbols
        SET emoji=?, label=?, color=?, weight=?, reward_points=?
        WHERE id=?
    ");
    $stmt->execute([$emoji,$label,$color,$weight,$reward_points,$id]);
} else {
    // novo
    $stmt = $pdo->prepare("
        INSERT INTO slot_symbols (emoji,label,color,weight,reward_points)
        VALUES (?,?,?,?,?)
    ");
    $stmt->execute([$emoji,$label,$color,$weight,$reward_points]);
}

header("Location: symbols.php");
exit;
