<?php
require_once __DIR__.'/../config.php';
require_login();
require_admin();

$rows = $pdo->query("SELECT id,label,emoji,color,weight,reward_points FROM slot_symbols ORDER BY id ASC")->fetchAll();
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width,initial-scale=1" />
<title>Símbolos • FideSlot Admin</title>
<meta name="color-scheme" content="dark" />
<style>
body{
  margin:0;background:#0b1220;color:#f8fafc;
  font-family:Inter,system-ui;
}
.wrap{
  max-width:1100px;
  margin:24px auto;
  padding:16px;
}
h1{
  margin:0 0 16px;
  font-size:20px;
  font-weight:700;
  color:#fff;
  display:flex;justify-content:space-between;flex-wrap:wrap;gap:10px;
}
.topnav{
  display:flex;
  flex-wrap:wrap;
  gap:10px;
}
.btn{
  border-radius:10px;
  border:1px solid #243357;
  background:#0b142b;
  color:#e5e7eb;
  padding:10px 12px;
  cursor:pointer;
  font-size:14px;
  text-decoration:none;
  display:inline-block;
}
.btn.danger{
  background:#2a0f14;
  border-color:#5b2333;
  color:#ffd2d2;
}
.tableWrap{
  background:#0e1729;
  border:1px solid #1e2948;
  border-radius:16px;
  box-shadow:0 24px 80px #000a;
  padding:16px;
  margin-bottom:24px;
}
.row{
  display:grid;
  grid-template-columns:80px 1fr 1fr 1fr 1fr 160px;
  gap:10px;
  align-items:center;
  border-top:1px solid #1e2948;
  padding:10px 0;
  font-size:14px;
}
.row:first-of-type{border-top:0;}
.row-head{
  font-size:12px;
  font-weight:600;
  color:#cbd5e1;
}
label{
  font-size:12px;
  color:#cbd5e1;
  display:block;
}
input[type="text"],input[type="number"],input[type="color"]{
  width:100%;
  border-radius:10px;
  border:1px solid #21325b;
  background:#0b142b;
  color:#fff;
  padding:8px 10px;
  font-size:14px;
}
.actions{
  display:flex;
  flex-wrap:wrap;
  gap:8px;
}
.note{
  font-size:12px;
  color:#9aa4b2;
}
</style>
</head>
<body>
<div class="wrap">
  <h1>
    <span>FideSlot • Símbolos</span>
    <span class="topnav">
      <a class="btn" href="index.php">← Voltar Admin Slot</a>
      <a class="btn" href="../fideslot.php" target="_blank">Abrir FideSlot</a>
      <a class="btn" href="../logout.php">Sair</a>
    </span>
  </h1>

  <div class="tableWrap">
    <div class="row row-head">
      <div>ID</div>
      <div>Emoji</div>
      <div>Nome</div>
      <div>Cor</div>
      <div>Peso</div>
      <div>Recompensa (3 iguais)</div>
    </div>

    <?php foreach($rows as $r): ?>
    <form class="row" method="post" action="save_symbol.php">
      <div>
        <strong>#<?php echo (int)$r['id']; ?></strong>
        <input type="hidden" name="id" value="<?php echo (int)$r['id']; ?>">
      </div>

      <div>
        <label>Emoji</label>
        <input type="text" name="emoji" value="<?php echo htmlspecialchars($r['emoji']); ?>" maxlength="10">
      </div>

      <div>
        <label>Nome</label>
        <input type="text" name="label" value="<?php echo htmlspecialchars($r['label']); ?>">
      </div>

      <div>
        <label>Cor</label>
        <input type="color" name="color" value="<?php echo htmlspecialchars($r['color']); ?>">
      </div>

      <div>
        <label>Peso</label>
        <input type="number" name="weight" step="0.1" min="0" value="<?php echo htmlspecialchars($r['weight']); ?>">
      </div>

      <div>
        <label>Pontos (3x iguais)</label>
        <input type="number" name="reward_points" step="1" min="0" value="<?php echo htmlspecialchars($r['reward_points']); ?>">
        <div class="actions" style="margin-top:8px">
          <button class="btn" type="submit">Salvar</button>
          <a class="btn danger" href="delete_symbol.php?id=<?php echo (int)$r['id']; ?>"
             onclick="return confirm('Apagar símbolo <?php echo htmlspecialchars($r['label']); ?> ?');">
            Apagar
          </a>
        </div>
      </div>
    </form>
    <?php endforeach; ?>

  </div>

  <div class="tableWrap">
    <h2 style="margin:0 0 12px;font-size:16px;font-weight:600;color:#fff">
      Novo símbolo
    </h2>
    <form class="row" method="post" action="save_symbol.php">
      <div style="font-size:12px;color:#9aa4b2">novo</div>

      <div>
        <label>Emoji</label>
        <input type="text" name="emoji" placeholder="🍒" maxlength="10" required>
      </div>

      <div>
        <label>Nome</label>
        <input type="text" name="label" placeholder="CEREJA" required>
      </div>

      <div>
        <label>Cor</label>
        <input type="color" name="color" value="#ffffff">
      </div>

      <div>
        <label>Peso</label>
        <input type="number" name="weight" step="0.1" min="0" value="1">
      </div>

      <div>
        <label>Pontos (3x iguais)</label>
        <input type="number" name="reward_points" step="1" min="0" value="0">
        <div class="actions" style="margin-top:8px">
          <button class="btn primary" type="submit">Adicionar</button>
        </div>
      </div>
    </form>
    <p class="note">
      Peso maior = mais comum no rolo. Se cair 3 símbolos iguais, o jogador
      recebe os pontos configurados aqui.
    </p>
  </div>
</div>
</body>
</html>
