<?php
require_once __DIR__.'/config.php';
require_login();

header('Content-Type: application/json; charset=utf-8');

$user = current_user($pdo);
$userId = $user['id'];

/* carrega config slot */
$stmt = $pdo->query("SELECT lock_hours, spin_cost FROM slot_config WHERE id=1");
$cfg  = $stmt->fetch();
$lock_hours = $cfg ? (int)$cfg['lock_hours'] : 24;
$spin_cost  = $cfg ? (int)$cfg['spin_cost']  : 0;

/* checa cooldown */
$now = time(); // seg
$nextFreeAt = 0;
if (!empty($user['ultimo_slot'])) {
    $lastSpin = strtotime($user['ultimo_slot']);
    $nextFreeAt = $lastSpin + ($lock_hours * 3600);
}

/* se ainda está bloqueado */
if ($nextFreeAt > $now) {
    $diff = $nextFreeAt - $now;
    $h = floor($diff/3600);
    $m = floor(($diff%3600)/60);
    $s = $diff%60;

    $remaining = str_pad($h,2,'0',STR_PAD_LEFT).":".
                 str_pad($m,2,'0',STR_PAD_LEFT).":".
                 str_pad($s,2,'0',STR_PAD_LEFT);

    echo json_encode([
        'error' => 'locked',
        'remaining' => $remaining
    ]);
    exit;
}

/* cobra custo se tiver spin_cost > 0 */
if ($spin_cost > 0 && $user['pontos_total'] < $spin_cost) {
    echo json_encode([
        'ok' => false,
        'error' => 'sem_pontos',
        'msg' => 'Pontos insuficientes para girar'
    ]);
    exit;
}

/* carrega símbolos disponíveis */
$symbolsStmt = $pdo->query("SELECT id,label,emoji,color,weight,reward_points FROM slot_symbols");
$symbols = $symbolsStmt->fetchAll();

if (!$symbols || count($symbols) === 0) {
    echo json_encode([
        'ok' => false,
        'error' => 'no_symbols',
        'msg' => 'Nenhum símbolo configurado'
    ]);
    exit;
}

/* sorteio ponderado */
function pickWeighted($symbols) {
    $totalW = 0;
    foreach ($symbols as $s) {
        $totalW += ($s['weight']>0 ? $s['weight'] : 0);
    }
    if ($totalW <= 0) { $totalW = count($symbols); }

    $r = mt_rand() / mt_getrandmax() * $totalW;
    foreach ($symbols as $s) {
        $w = ($s['weight']>0 ? $s['weight'] : 0);
        $r -= $w;
        if ($r <= 0) {
            return $s;
        }
    }
    return $symbols[count($symbols)-1];
}

/* sorteia os 3 rolos */
$slot1 = pickWeighted($symbols);
$slot2 = pickWeighted($symbols);
$slot3 = pickWeighted($symbols);

$reels = [$slot1['emoji'],$slot2['emoji'],$slot3['emoji']];

/* calcula prêmio */
$win = false;
$added_points = 0;
$chosenSymbol = $slot1; // default
if ($slot1['id'] == $slot2['id'] && $slot2['id'] == $slot3['id']) {
    // três iguais
    $win = true;
    $added_points = (int)$slot1['reward_points'];
    $chosenSymbol = $slot1;
}

/* aplica custo do giro + recompensa final */
$newTotal = (int)$user['pontos_total'];

/* desconta custo se houver */
if ($spin_cost > 0) {
    $newTotal -= $spin_cost;
    if ($newTotal < 0) $newTotal = 0;
}

/* adiciona pontos se ganhou */
if ($win && $added_points > 0) {
    $newTotal += $added_points;
}

/* salva no banco */
$pdo->beginTransaction();
try {
    $upd = $pdo->prepare("
        UPDATE users
        SET pontos_total = ?, ultimo_slot = NOW()
        WHERE id = ?
    ");
    $upd->execute([$newTotal,$userId]);

    $pdo->commit();
} catch(Exception $e) {
    $pdo->rollBack();
    echo json_encode([
        'ok' => false,
        'error' => 'db_fail',
        'msg' => 'Falha ao salvar resultado'
    ]);
    exit;
}

/* timestamp ms do próximo giro liberado */
$next_free_ms = ($now + ($lock_hours*3600)) * 1000;

echo json_encode([
    'ok' => true,
    'reels' => $reels,
    'win'   => $win,
    'symbol'=> [
        'label' => $chosenSymbol['label'],
        'emoji' => $chosenSymbol['emoji'],
        'color' => $chosenSymbol['color'],
        'reward_points' => (int)$chosenSymbol['reward_points']
    ],
    'added_points' => $win ? $added_points : 0,
    'new_total'    => $newTotal,
    'next_free_at' => $next_free_ms
]);
exit;
