<?php
$DB_HOST = "localhost";
$DB_NAME = "gamefid_roleta";
$DB_USER = "root";
$DB_PASS = "";

try {
    $pdo = new PDO(
        "mysql:host=$DB_HOST;dbname=$DB_NAME;charset=utf8mb4",
        $DB_USER,
        $DB_PASS,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
        ]
    );
} catch (Exception $e) {
    die("erro ao conectar banco: ".$e->getMessage());
}

session_start();

function require_login() {
    if (!isset($_SESSION['user_id'])) {
        header("Location: login.php");
        exit;
    }
}
function is_admin() {
    return isset($_SESSION['is_admin']) && $_SESSION['is_admin'] == 1;
}
function require_admin() {
    if (!is_admin()) {
        header("Location: ../login.php");
        exit;
    }
}
function current_user(PDO $pdo) {
    if (!isset($_SESSION['user_id'])) return null;
    $st = $pdo->prepare("SELECT id, nome, email, pontos_total, ultimo_giro, is_admin FROM users WHERE id=?");
    $st->execute([$_SESSION['user_id']]);
    return $st->fetch();
}
function fmt_pts($n){
    return number_format((int)$n,0,',','.');
}
?>
