-- MySQL schema inicial para gamefid_roleta

CREATE TABLE users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  nome VARCHAR(80) NOT NULL,
  email VARCHAR(120) NOT NULL UNIQUE,
  senha_hash VARCHAR(255) NOT NULL,
  pontos_total INT NOT NULL DEFAULT 0,
  ultimo_giro DATETIME NULL,
  is_admin TINYINT(1) NOT NULL DEFAULT 0,
  criado_em DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE wheel_config (
  id INT PRIMARY KEY DEFAULT 1,
  lock_hours INT NOT NULL DEFAULT 24,
  tick_every INT NOT NULL DEFAULT 10,
  logo_src VARCHAR(255) NOT NULL DEFAULT 'assets/img/r1.png'
);

INSERT INTO wheel_config (id, lock_hours, tick_every, logo_src)
VALUES (1,24,10,'assets/img/r1.png')
ON DUPLICATE KEY UPDATE lock_hours=VALUES(lock_hours);

CREATE TABLE prizes (
  id INT AUTO_INCREMENT PRIMARY KEY,
  sort_order INT NOT NULL,
  label VARCHAR(120) NOT NULL,
  color VARCHAR(16) NOT NULL,
  weight FLOAT NOT NULL DEFAULT 1,
  reward_points INT NOT NULL DEFAULT 0
);

INSERT INTO prizes (sort_order,label,color,weight,reward_points) VALUES
(1,'10 REAIS','#f6bf26',1,100),
(2,'Não foi dessa vez','#ef4444',1,0),
(3,'25 RODADAS','#0ea5e9',1,250),
(4,'Brinde','#22c55e',1,50),
(5,'5 REAIS','#a78bfa',1,60),
(6,'Frete Grátis','#06b6d4',1,40),
(7,'Adesivo','#ff6b6b',1,20),
(8,'Desconto 10%','#10b981',1,30);

CREATE TABLE spins (
  id INT AUTO_INCREMENT PRIMARY KEY,
  user_id INT NOT NULL,
  prize_id INT NOT NULL,
  pontos_ganhos INT NOT NULL DEFAULT 0,
  created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (user_id) REFERENCES users(id),
  FOREIGN KEY (prize_id) REFERENCES prizes(id)
);
