<?php
require_once __DIR__.'/config.php';
require_login();

$top = $pdo->query("SELECT nome,pontos_total FROM users ORDER BY pontos_total DESC, id ASC LIMIT 50")->fetchAll();
$me = current_user($pdo);

$posStmt = $pdo->prepare("SELECT COUNT(*)+1 AS pos FROM users WHERE pontos_total > ?");
$posStmt->execute([$me['pontos_total']]);
$myPos = $posStmt->fetch()['pos'] ?? 1;
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width,initial-scale=1" />
<title>Ranking • Gamefid</title>
<meta name="color-scheme" content="dark" />
<style>
:root{
 --bg:#0b1220;--panel:#0e1729dd;--border:#1e2948;--ink:#f8fafc;
 --muted:#9aa4b2;--gold:#ffd54d;
}
body{margin:0;background:
 radial-gradient(1200px 800px at 80% -15%,#153066 0%,#0a142a 55%),
 radial-gradient(1000px 720px at 18% 120%,#0c2455 0%,#0a142a 60%);
color:var(--ink);font-family:Inter,system-ui}
.topbar{background:#0e1729dd;border-bottom:1px solid var(--border);backdrop-filter:blur(18px) saturate(150%);
padding:12px 16px;text-align:center;font-size:14px;box-shadow:0 24px 80px #000a}
.topbar a{color:var(--gold);text-decoration:none;font-weight:600}
.wrap{max-width:480px;margin:24px auto;padding:16px;display:grid;gap:16px}
h1{margin:0;font-size:20px;font-weight:600;text-align:center;color:#fff}
.me{background:#0e1729dd;border:1px solid var(--border);border-radius:16px;padding:14px 16px;box-shadow:0 24px 80px #000a}
.me b{color:var(--gold)}
.table{border:1px solid var(--border);border-radius:16px;overflow:hidden;background:#0e1729dd;box-shadow:0 24px 80px #000a}
.row{display:flex;justify-content:space-between;padding:10px 14px;border-top:1px solid #1c2a44;font-size:14px}
.row:first-child{border-top:0}
.pos{color:#94a3b8;width:32px;font-variant-numeric:tabular-nums}
.nome{flex:1;color:#fff;overflow:hidden;text-overflow:ellipsis;white-space:nowrap}
.pts{color:var(--gold);font-weight:600;font-variant-numeric:tabular-nums}
</style>
</head>
<body>
<div class="topbar">
  <a href="roleta.php">← Voltar para a roleta</a>
</div>

<div class="wrap">
  <h1>Ranking Geral</h1>

  <div class="me">
    <div style="font-size:14px;margin-bottom:6px;color:#cbd5e1">Sua posição geral:</div>
    <div style="font-size:28px;font-weight:700;line-height:1;color:#fff"><b>#<?php echo (int)$myPos; ?></b></div>
    <div style="font-size:14px;margin-top:8px;color:#fff">
      <?php echo htmlspecialchars($me['nome']); ?> — <b><?php echo fmt_pts($me['pontos_total']); ?> pts</b>
    </div>
  </div>

  <div class="table">
    <?php $i=1; foreach ($top as $row): ?>
      <div class="row" <?php if($row['nome']===$me['nome']) echo 'style="background:#1a2545"'; ?>>
        <div class="pos">#<?php echo $i++; ?></div>
        <div class="nome"><?php echo htmlspecialchars($row['nome']); ?></div>
        <div class="pts"><?php echo fmt_pts($row['pontos_total']); ?> pts</div>
      </div>
    <?php endforeach; ?>
  </div>
</div>
</body>
</html>
