<?php
require_once __DIR__.'/config.php';
if (isset($_SESSION['user_id'])) {
    header("Location: roleta.php");
    exit;
}
$err = "";
if ($_SERVER['REQUEST_METHOD']==='POST') {
    $nome = trim($_POST['nome'] ?? "");
    $email = trim($_POST['email'] ?? "");
    $senha = $_POST['senha'] ?? "";
    if ($nome==="" || $email==="" || $senha==="") {
        $err = "Preencha tudo.";
    } else {
        $st = $pdo->prepare("SELECT id FROM users WHERE email=?");
        $st->execute([$email]);
        if ($st->fetch()) {
            $err = "Email já cadastrado.";
        } else {
            $hash = password_hash($senha, PASSWORD_DEFAULT);
            $st = $pdo->prepare("INSERT INTO users (nome,email,senha_hash) VALUES (?,?,?)");
            $st->execute([$nome,$email,$hash]);
            $_SESSION['user_id'] = $pdo->lastInsertId();
            $_SESSION['is_admin'] = 0;
            header("Location: roleta.php");
            exit;
        }
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>Criar conta • Gamefid</title>
<meta name="color-scheme" content="dark">
<style>
:root{
  --bg:#0b1220;--panel:#0e1729dd;--border:#1e2948;--ink:#f8fafc;
  --muted:#9aa4b2;--brand:#ffd54d;--brand2:#ffe082;
}
*{box-sizing:border-box}
body,html{margin:0;height:100%;background:
 radial-gradient(1200px 800px at 80% -15%,#153066 0%,#0a142a 55%),
 radial-gradient(1000px 720px at 18% 120%,#0c2455 0%,#0a142a 60%);
color:var(--ink);font-family:Inter,system-ui}
.wrap{
 max-width:380px;margin:clamp(40px,8vh,80px) auto;padding:24px;
 background:var(--panel);border:1px solid var(--border);border-radius:24px;
 backdrop-filter:blur(18px) saturate(150%);
 box-shadow:0 32px 80px #000a;
 display:grid;gap:16px;text-align:left
}
.headline{font-size:clamp(20px,3vw,24px);font-weight:700;margin:0;color:#fff;line-height:1.2}
.sub{margin:0;font-size:13px;color:var(--muted);line-height:1.4}
label{font-size:12px;color:#cbd5e1;display:block;margin-bottom:4px}
.input-wrap{position:relative}
.input{
 width:100%;border-radius:12px;border:1px solid #21325b;background:#0b142b;
 color:#fff;padding:14px 44px 14px 44px;font-size:15px;
}
.icon{position:absolute;left:14px;top:50%;transform:translateY(-50%);width:18px;height:18px;opacity:.8;fill:#94a3b8}
.err{color:#f87171;font-size:13px;min-height:16px}
.btn{
 width:100%;border-radius:12px;border:0;background:linear-gradient(135deg,var(--brand),var(--brand2));
 color:#0a1222;font-weight:700;padding:14px 16px;cursor:pointer;
 box-shadow:0 18px 40px #ffd54d55;font-size:15px
}
.alt{font-size:13px;color:#9aa4b2;text-align:center}
.alt a{color:#ffd54d;text-decoration:none;font-weight:600}
.brand{font-size:12px;color:#9aa4b2;text-align:center}
</style>
</head>
<body>
<div class="wrap<?php echo $err?' shake':''; ?>" style="@keyframes shake{10%,90%{transform:translateX(-1px)}20%,80%{transform:translateX(2px)}30%,50%,70%{transform:translateX(-4px)}40%,60%{transform:translateX(4px)}}.shake{animation:shake .42s cubic-bezier(.36,.07,.19,.97) both}">
  <div>
    <h1 class="headline">Criar sua conta</h1>
    <p class="sub">Ganhe pontos diários, suba no ranking e desbloqueie recompensas.</p>
  </div>

  <form method="post" style="display:grid;gap:14px">
    <div>
      <label>Nome</label>
      <div class="input-wrap">
        <svg class="icon" viewBox="0 0 24 24"><path d="M12 12a5 5 0 1 0-5-5 5 5 0 0 0 5 5Zm0 2c-4.33 0-8 2.17-8 5v1h16v-1c0-2.83-3.67-5-8-5Z"/></svg>
        <input class="input" name="nome" required>
      </div>
    </div>

    <div>
      <label>E-mail</label>
      <div class="input-wrap">
        <svg class="icon" viewBox="0 0 24 24"><path d="M2 6v12h20V6Zm10 7L4 8h16Z" /></svg>
        <input class="input" name="email" type="email" required>
      </div>
    </div>

    <div>
      <label>Senha</label>
      <div class="input-wrap">
        <svg class="icon" viewBox="0 0 24 24"><path d="M17 8V7a5 5 0 0 0-10 0v1H5v12h14V8Zm-8 0V7a3 3 0 0 1 6 0v1Z"/></svg>
        <input class="input" name="senha" type="password" required>
      </div>
    </div>

    <div class="err"><?php echo htmlspecialchars($err); ?></div>

    <button class="btn" type="submit">Criar conta</button>
  </form>

  <div class="alt">Já tem conta? <a href="login.php">Entrar</a></div>
  <div class="brand">Gamefid • Dia Studio</div>
</div>
</body>
</html>
