<?php
require_once __DIR__.'/config.php';
require_login();
$me = current_user($pdo);
$firstLetter = mb_strtoupper(mb_substr($me['nome'],0,1));
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>Roleta Diária — Gamefid</title>
<meta name="color-scheme" content="dark" />
<style>
:root{
 --bg:#0b1220; --panel:#0e1729dd; --border:#1c2a44; --muted:#9aa4b2; --ink:#eaf0ff;
 --gold:#ffd54d; --gold2:#ffe082; --sliceLine:#0a1222;
}
*{box-sizing:border-box}
html,body{
 margin:0;height:100%;
 background:
  radial-gradient(1400px 900px at 50% -20%, #10275a 0%, #0a1222 45%),
  radial-gradient(1000px 700px at 50% 120%, #0b1f4a 0%, #0a1222 60%);
 color:var(--ink); font-family:Inter,ui-sans-serif,system-ui
}
.topbar{
 position:sticky;top:0;z-index:30;
 background:var(--panel);border-bottom:1px solid var(--border);
 backdrop-filter:blur(18px) saturate(150%);
 box-shadow:0 24px 80px #000a;
}
.top-inner{
 max-width:480px;margin:0 auto;
 padding:12px 16px;
 display:flex;align-items:center;justify-content:space-between;gap:10px;flex-wrap:wrap
}
.userbox{display:flex;align-items:center;gap:10px}
.avatar{
 width:36px;height:36px;border-radius:12px;
 background:radial-gradient(circle at 30% 30%,#7c3aed 0%,#0ea5e9 60%);
 color:#fff;font-weight:700;font-size:14px;display:grid;place-items:center;
 box-shadow:0 18px 40px #000a
}
.userinfo{font-size:12px;line-height:1.3;color:#fff}
.userinfo .name{font-weight:600;color:#fff;font-size:13px}
.userinfo .pts{color:var(--gold);font-weight:700}
.links{font-size:12px;display:flex;gap:10px;flex-wrap:wrap}
.links a{
 background:#0b142b;border:1px solid #243357;border-radius:10px;
 color:#e5e7eb;padding:8px 10px;font-size:12px;text-decoration:none;line-height:1;
 box-shadow:0 16px 40px #000a
}

.wrap{max-width:480px;margin:0 auto;padding:14px 12px 80px;min-height:100dvh;display:grid;gap:14px}
.top{display:grid;place-items:center;gap:10px;text-align:center}
.subtitle{margin:0;color:#cdd6e3}
.timer{display:flex;align-items:center;justify-content:center;gap:10px;font-weight:900;
 font-size:clamp(20px,6.5vw,30px);font-variant-numeric:tabular-nums}
.timer .fire{
 width:24px;height:24px;display:grid;place-items:center;border-radius:9px;
 background:radial-gradient(60% 80% at 30% 20%, #ff9f1c, #ff5f1e 60%);
 box-shadow:0 6px 20px #ff6a0033
}
.hint{margin:-4px 0 6px;text-align:center;color:#9fb0d4;font-size:12px}
.statusline{font-size:13px;color:#9fb0d4;min-height:16px}

.stage{position:relative;display:grid;place-items:center}
.wheel-box{position:relative;width:min(380px,92vw);aspect-ratio:1/1;}
#wheel{position:relative;z-index:1;width:100%;height:100%;display:block;filter:drop-shadow(0 24px 48px #000a)}
.pin{
 position:absolute;top:-10px;left:50%;transform:translateX(-50%);
 width:0;height:0;border-left:14px solid transparent;border-right:14px solid transparent;border-bottom:26px solid var(--gold);
 filter:drop-shadow(0 6px 10px #0008);z-index:2;border-radius:4px
}
.center-btn{position:absolute;inset:0;display:grid;place-items:center;pointer-events:none}
.spin{
 pointer-events:auto;width:86px;height:86px;border-radius:999px;border:0;cursor:pointer;
 background:radial-gradient(120px 120px at 30% 30%, var(--gold2), var(--gold) 60%);
 color:#0a1222;font-weight:900;box-shadow:0 14px 40px #000a,inset 0 8px 18px #ffffff55;display:grid;place-items:center
}
.spin svg{width:28px;height:28px}
.spin:active{transform:scale(.98)}
.spin[disabled]{filter:grayscale(.45);opacity:.75;cursor:not-allowed}
.status{text-align:center;color:#9fb0d4;font-size:12px;margin-top:2px;min-height:18px}
.footer{font-size:12px;color:#9aa4b2;text-align:center;margin-top:20px}
.footer a{color:#9aa4b2;text-decoration:none}

/* modal resultado */
.modal{
 position:fixed;inset:0;z-index:60;display:none;place-items:center;
 background:#0008;
}
.modal-box{
 width:min(420px,92vw);
 background:var(--panel);border:1px solid var(--border);border-radius:16px;
 box-shadow:0 32px 100px #000a;color:#fff;
}
.modal-hd{
 padding:12px 16px;border-bottom:1px solid var(--border);
 display:flex;align-items:center;justify-content:space-between;
 font-size:14px;font-weight:600;color:#fff
}
.modal-close{
 background:transparent;border:1px solid var(--border);color:#cbd5e1;
 border-radius:10px;padding:6px 10px;cursor:pointer;font-size:13px
}
.modal-bd{padding:18px 16px;color:#cbd5e1;font-size:14px}
.modal-bd h2{
 margin:0 0 12px;font-size:24px;line-height:1.15;font-weight:700;color:#fff
}
.badgeColor{
 width:14px;height:14px;border-radius:999px;box-shadow:0 0 0 2px #0b1220,0 0 0 3px #1c2a4d;
}
</style>
</head>
<body>
<header class="topbar">
  <div class="top-inner">
    <div class="userbox">
      <div class="avatar"><?php echo htmlspecialchars($firstLetter); ?></div>
      <div class="userinfo">
        <div class="name"><?php echo htmlspecialchars($me['nome']); ?></div>
        <div class="pts"><span id="saldo"><?php echo fmt_pts($me['pontos_total']); ?></span> pts</div>
      </div>
    </div>
    <div class="links">
      <a href="ranking.php">Ranking</a>
      <?php if(is_admin()): ?><a href="admin/">Admin</a><?php endif; ?>
      <a href="logout.php">Sair</a>
    </div>
  </div>
</header>

<div class="wrap">
  <div class="top">
    <p class="subtitle">Gire a roleta e conquiste prêmios! 🎁</p>
    <div class="timer"><span class="fire" aria-hidden="true">🔥</span><span id="countdown">--:--:--</span></div>
    <div id="hint" class="hint">Carregando…</div>
    <div class="statusline" id="statusTop"></div>
  </div>

  <div class="stage">
    <div class="wheel-box">
      <div class="pin" aria-hidden="true"></div>
      <canvas id="wheel" role="img" aria-label="Roleta de prêmios"></canvas>
      <div class="center-btn"><button id="spinBtn" class="spin" aria-label="Girar">
        <svg viewBox="0 0 24 24" fill="none"><path d="M12 6V3L8 7l4 4V8a4 4 0 1 1-4 4H6a6 6 0 1 0 6-6Z" fill="#0a1222"/></svg>
      </button></div>
    </div>
    <div id="status" class="status"></div>
  </div>

  <div class="footer">
    Desenvolvido por <strong>Dia Studio</strong>
  </div>
</div>

<div id="resultModal" class="modal" aria-hidden="true">
  <div class="modal-box">
    <div class="modal-hd">
      <span>Resultado</span>
      <button class="modal-close" id="modalClose">Fechar</button>
    </div>
    <div class="modal-bd">
      <p style="margin:0 0 8px">Você ganhou:</p>
      <h2 id="modalPrize">---</h2>
      <div style="display:flex;align-items:center;gap:10px;margin-bottom:12px">
        <span id="modalColor" class="badgeColor" style="background:#fff"></span>
        <small style="color:#9aa4b2">Cor do setor</small>
      </div>
      <div style="font-size:13px;color:#9aa4b2" id="modalPoints">+0 pts adicionados à sua conta</div>
    </div>
  </div>
</div>

<script>
let config=null;
let lockHours=24;

const cvs=document.getElementById('wheel');
const ctx=cvs.getContext('2d');
const spinBtn=document.getElementById('spinBtn');
const statusEl=document.getElementById('status');
const statusTop=document.getElementById('statusTop');
const countdownEl=document.getElementById('countdown');
const hintEl=document.getElementById('hint');
const saldoEl=document.getElementById('saldo');
const dpr=Math.max(1,window.devicePixelRatio||1);

const modal=document.getElementById('resultModal');
const modalClose=document.getElementById('modalClose');
const modalPrize=document.getElementById('modalPrize');
const modalColor=document.getElementById('modalColor');
const modalPoints=document.getElementById('modalPoints');

let size,radius,center,rot=0,spinning=false;
let lastTickAngle=0;

const ac=new (window.AudioContext||window.webkitAudioContext)();
function tickSound(){
  const o=ac.createOscillator(),g=ac.createGain();
  o.type='square';o.frequency.value=2400;
  g.gain.value=0.03;o.connect(g);g.connect(ac.destination);
  o.start();o.stop(ac.currentTime+0.03);
}
function openModal(prizeLabel, prizeColor, pts){
  modalPrize.textContent=prizeLabel;
  modalColor.style.background=prizeColor;
  modalPoints.textContent = "+"+pts+" pts adicionados à sua conta";
  modal.style.display='grid';
}
function closeModal(){
  modal.style.display='none';
}
modalClose.addEventListener('click',closeModal);
modal.addEventListener('click',e=>{if(e.target===modal)closeModal();});

function shade(hex,amt){
  let c=hex.replace('#','');if(c.length===3)c=c.split('').map(x=>x+x).join('');
  const num=parseInt(c,16);
  let r=(num>>16)&255,g=(num>>8)&255,b=num&255;
  r=Math.min(255,Math.max(0,Math.round(r+amt*255)));
  g=Math.min(255,Math.max(0,Math.round(g+amt*255)));
  b=Math.min(255,Math.max(0,Math.round(b+amt*255)));
  return `#${(r<<16|g<<8|b).toString(16).padStart(6,'0')}`;
}
function wrapText(ctx,t,x,y,maxW,lh){
  const w=String(t).split(' ');let line='',lines=[];
  for(const ww of w){
    const test=line?line+' '+ww:ww;
    if(ctx.measureText(test).width>maxW&&line){lines.push(line);line=ww;}else line=test;
  }
  lines.push(line);
  const H=lines.length*lh*0.9;
  let yy=y-H/2+lh*0.45;
  for(const l of lines){ctx.fillText(l,x,yy);yy+=lh*0.9;}
}
function ring(r,color,lw){
  ctx.beginPath();ctx.arc(0,0,r,0,Math.PI*2);ctx.lineWidth=lw;ctx.strokeStyle=color;ctx.stroke();
}
function hub(r){
  const g=ctx.createRadialGradient(-r*0.3,-r*0.3,r*0.3,0,0,r);
  g.addColorStop(0,'#fefefe');g.addColorStop(1,'#cbd5e1');
  ctx.fillStyle=g;ctx.beginPath();ctx.arc(0,0,r,0,Math.PI*2);ctx.fill();
  ctx.strokeStyle='#0b142b';ctx.lineWidth=r*0.18;ctx.stroke();
}
function faceGloss(r){
  const g=ctx.createRadialGradient(-r*0.25,-r*0.25,r*0.1,0,0,r);
  g.addColorStop(0,'rgba(255,255,255,.12)');g.addColorStop(1,'rgba(255,255,255,0)');
  ctx.fillStyle=g;ctx.beginPath();ctx.arc(0,0,r*0.98,0,Math.PI*2);ctx.fill();
}
function resize(){
  const r=cvs.getBoundingClientRect();
  const w=Math.floor(r.width*dpr),h=Math.floor(r.height*dpr);
  cvs.width=w;cvs.height=h;
  size=Math.min(w,h);radius=size/2 * 0.90;
  center={x:w/2,y:h/2};
  draw();
}
window.addEventListener('resize',resize);

function draw(){
  if(!config)return;
  const prizes=config.prizes;
  const n=prizes.length,seg=Math.PI*2/n;
  ctx.clearRect(0,0,cvs.width,cvs.height);
  ctx.save();ctx.translate(center.x,center.y);ctx.rotate(rot);

  const outer=radius*1.02;
  const g0=ctx.createRadialGradient(0,0,radius*0.1,0,0,outer);
  g0.addColorStop(0,'#1f293733');g0.addColorStop(1,'#000000aa');
  ctx.fillStyle=g0;ctx.beginPath();ctx.arc(0,0,outer+12,0,Math.PI*2);ctx.fill();

  for(let i=0;i<n;i++){
    const s=i*seg,e=s+seg;
    ctx.beginPath();ctx.moveTo(0,0);ctx.arc(0,0,radius,s,e);ctx.closePath();

    const c=prizes[i].color||'#64748b';
    const g=ctx.createLinearGradient(Math.cos(s)*radius,Math.sin(s)*radius,Math.cos(e)*radius,Math.sin(e)*radius);
    g.addColorStop(0,shade(c,0.22));g.addColorStop(1,c);
    ctx.fillStyle=g;ctx.fill();

    ctx.strokeStyle=getComputedStyle(document.documentElement).getPropertyValue('--sliceLine')||'#0a1222';
    ctx.lineWidth=Math.max(2,radius*0.015);
    ctx.stroke();
  }

  ring(radius*1.00,'#091227',radius*0.065);
  ring(radius*0.78,'#0b142b',radius*0.028);
  faceGloss(radius);

  ctx.fillStyle='#fff';ctx.textAlign='center';ctx.textBaseline='middle';
  ctx.font=`${Math.max(12,radius*0.085)}px system-ui`;
  for(let i=0;i<n;i++){
    const a=(i+0.5)*seg;
    ctx.save();ctx.rotate(a);ctx.translate(radius*0.60,0);
    const global=(rot+a)%(Math.PI*2);
    if(global>Math.PI/2 && global<3*Math.PI/2)ctx.rotate(Math.PI);
    wrapText(ctx,prizes[i].label,0,0,radius*0.50,Math.max(10,radius*0.085));
    ctx.restore();
  }
  hub(radius*0.25);
  ctx.restore();
}

function normalize(d){const two=Math.PI*2;while(d<0)d+=two;return d;}

function spin(){
  if(spinning)return;
  spinning=true;
  spinBtn.disabled=true;
  statusEl.textContent='Girando...';

  fetch('spin.php',{method:'POST'})
    .then(r=>r.json())
    .then(data=>{
      if(data.error==='locked'){
        statusEl.textContent='Aguarde o próximo giro';
        statusTop.textContent='Bloqueado. Falta '+data.remaining;
        spinning=false;
        spinBtn.disabled=true;
        return;
      }
      if(!data.ok){
        statusEl.textContent='Erro ao girar';
        spinning=false;
        spinBtn.disabled=false;
        return;
      }

      const idx=config.prizes.findIndex(p=>p.label===data.prize.label && p.color===data.prize.color);
      const n=config.prizes.length;
      const seg=Math.PI*2/n;
      const base=-Math.PI/2 - ((idx+0.5)*seg);
      const turns=Math.floor(Math.random()*(7-5+1))+5;
      const target=base+turns*Math.PI*2;
      const start=rot;
      const delta=normalize(target-start);
      const dur=5200;
      const t0=performance.now();
      lastTickAngle=rot;

      function anim(now){
        const t=Math.min(1,(now-t0)/dur);
        const e=1-Math.pow(1-t,3);
        rot=start+delta*e;
        draw();

        const tickStep=(config.tickEvery||10)*Math.PI/180;
        if(Math.abs(rot-lastTickAngle)>=tickStep){
          lastTickAngle=rot;
          try{ac.resume&&ac.resume();}catch(_){}
          tickSound();
        }

        if(t<1){requestAnimationFrame(anim);}
        else{
          const snapped=base%(Math.PI*2);
          rot=((snapped%(Math.PI*2))+Math.PI*4)%(Math.PI*2);
          draw();
          spinning=false;

          saldoEl.textContent=new Intl.NumberFormat('pt-BR').format(data.new_total);
          statusEl.textContent='Você ganhou: '+data.prize.label+' (+'+data.prize.points+' pts)';
          statusTop.textContent='Resultado: '+data.prize.label;
          openModal(data.prize.label, data.prize.color, data.prize.points);
        }
      }
      requestAnimationFrame(anim);
    })
    .catch(()=>{
      statusEl.textContent='Erro de rede';
      spinning=false;
      spinBtn.disabled=false;
    });
}

function tickCountdown(){
  hintEl.textContent='1 giro disponível a cada '+lockHours+' horas';
}
setInterval(tickCountdown,1000);

function init(){
  fetch('get_config.php')
    .then(r=>r.json())
    .then(cfg=>{
      config=cfg;
      lockHours=cfg.lockHours||24;
      resize();
      draw();
      tickCountdown();
    });
}
window.addEventListener('load',init);
spinBtn.addEventListener('click',()=>{try{ac.resume&&ac.resume();}catch(e){}spin();});
cvs.addEventListener('click',()=>{try{ac.resume&&ac.resume();}catch(e){}spin();});
</script>
</body>
</html>
