<?php
require_once __DIR__.'/../config.php';
require_login();
require_admin();

$cfgStmt = $pdo->query("SELECT lock_hours,tick_every,logo_src FROM wheel_config WHERE id=1");
$cfg = $cfgStmt->fetch();
if(!$cfg){ $cfg=['lock_hours'=>24,'tick_every'=>10,'logo_src'=>'assets/img/r1.png']; }

?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width,initial-scale=1" />
<title>Admin • Gamefid Roleta</title>
<meta name="color-scheme" content="dark" />
<style>
body{margin:0;background:#0b1220;color:#f8fafc;font-family:Inter,system-ui}
.wrap{max-width:1100px;margin:24px auto;padding:16px}
h1{margin:0 0 16px;font-size:20px;font-weight:700;color:#fff;display:flex;justify-content:space-between;flex-wrap:wrap;gap:10px}
.card{background:#0e1729;border:1px solid #1e2948;border-radius:16px;padding:16px;margin-bottom:20px;box-shadow:0 24px 80px #000a}
label{font-size:13px;color:#cbd5e1;display:block;margin-bottom:4px}
input{width:100%;border-radius:10px;border:1px solid #21325b;background:#0b142b;color:#fff;padding:10px 12px;font-size:14px}
.btn{border-radius:10px;border:1px solid #243357;background:#0b142b;color:#e5e7eb;padding:10px 12px;cursor:pointer;font-size:14px;text-decoration:none;display:inline-block}
.btn.primary{border-color:#4c2dbd;background:linear-gradient(135deg,#ffd54d,#ffe082);color:#0a1222;font-weight:900;box-shadow:0 12px 30px #ffd54d44}
.grid{display:grid;grid-template-columns:repeat(auto-fit,minmax(200px,1fr));gap:12px}
a.btnlink{color:#e5e7eb;text-decoration:none}
.topnav{display:flex;flex-wrap:wrap;gap:10px}
</style>
</head>
<body>
<div class="wrap">
  <h1>
    <span>Painel Admin — Gamefid Roleta</span>
    <span class="topnav">
      <a class="btn" href="../roleta.php" target="_blank">Abrir Roleta</a>
      <a class="btn" href="prizes.php">Prêmios</a>
      <a class="btn" href="../logout.php">Sair</a>
    </span>
  </h1>

  <div class="card">
    <h2 style="margin:0 0 12px;font-size:16px;font-weight:600;color:#fff">Configuração Geral</h2>
    <form method="post" action="save_config.php" class="grid">
      <div>
        <label>Bloqueio (horas)</label>
        <input name="lock_hours" type="number" min="1" value="<?php echo (int)$cfg['lock_hours'];?>">
      </div>
      <div>
        <label>"Tick" (graus)</label>
        <input name="tick_every" type="number" min="5" value="<?php echo (int)$cfg['tick_every'];?>">
      </div>
      <div>
        <label>Logo caminho</label>
        <input name="logo_src" value="<?php echo htmlspecialchars($cfg['logo_src']);?>">
      </div>
      <div style="align-self:end">
        <button class="btn primary" type="submit">Salvar config</button>
      </div>
    </form>
    <p style="font-size:12px;color:#9aa4b2;margin-top:12px">A roleta lê direto do MySQL. Após salvar, os jogadores já usam o novo bloqueio e prêmios.</p>
  </div>

  <div class="card">
    <h2 style="margin:0 0 12px;font-size:16px;font-weight:600;color:#fff">Gerenciar prêmios</h2>
    <p style="font-size:14px;color:#cbd5e1;margin:0 0 12px">Adicione, edite, apague ou reordene as fatias da roleta.</p>
    <a class="btn" href="prizes.php">Abrir Gerenciador de Prêmios →</a>
  </div>
</div>
</body>
</html>
