<?php
require_once __DIR__.'/../config.php';
require_login();
require_admin();

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$err = "";
$label=""; $color="#ffffff"; $weight="1"; $reward="0";

if ($id) {
    $st = $pdo->prepare("SELECT * FROM prizes WHERE id=?");
    $st->execute([$id]);
    $row = $st->fetch();
    if ($row) {
        $label = $row['label'];
        $color = $row['color'];
        $weight= $row['weight'];
        $reward= $row['reward_points'];
    }
}

if ($_SERVER['REQUEST_METHOD']==='POST') {
    $label  = trim($_POST['label'] ?? "");
    $color  = trim($_POST['color'] ?? "#ffffff");
    $weight = floatval($_POST['weight'] ?? 1);
    $reward = (int)($_POST['reward_points'] ?? 0);

    if ($label==="") {
        $err="Informe o nome do prêmio.";
    } else {
        if ($id) {
            $st = $pdo->prepare("UPDATE prizes SET label=?, color=?, weight=?, reward_points=? WHERE id=?");
            $st->execute([$label,$color,$weight,$reward,$id]);
        } else {
            // novo sort_order = último +1
            $last = $pdo->query("SELECT COALESCE(MAX(sort_order),0)+1 AS nxt FROM prizes")->fetch();
            $nxt = $last ? (int)$last['nxt'] : 1;
            $st = $pdo->prepare("INSERT INTO prizes (sort_order,label,color,weight,reward_points) VALUES (?,?,?,?,?)");
            $st->execute([$nxt,$label,$color,$weight,$reward]);
            $id = $pdo->lastInsertId();
        }
        header("Location: prizes.php");
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width,initial-scale=1" />
<title><?php echo $id?'Editar':'Novo'; ?> Prêmio • Admin</title>
<meta name="color-scheme" content="dark" />
<style>
body{margin:0;background:#0b1220;color:#f8fafc;font-family:Inter,system-ui}
.wrap{max-width:480px;margin:24px auto;padding:16px}
h1{margin:0 0 16px;font-size:20px;font-weight:700;color:#fff;display:flex;justify-content:space-between;flex-wrap:wrap;gap:10px}
.card{background:#0e1729;border:1px solid #1e2948;border-radius:16px;padding:16px;margin-bottom:20px;box-shadow:0 24px 80px #000a}
label{font-size:13px;color:#cbd5e1;display:block;margin-bottom:4px}
input[type="text"],input[type="number"],input[type="color"]{
 width:100%;border-radius:10px;border:1px solid #21325b;background:#0b142b;color:#fff;
 padding:12px;font-size:14px;margin-bottom:12px
}
.err{color:#f87171;font-size:13px;min-height:16px;margin-bottom:12px}
.rowflex{display:grid;grid-template-columns:1fr 1fr;gap:12px}
.btn{border-radius:10px;border:1px solid #243357;background:#0b142b;color:#e5e7eb;padding:12px;font-size:14px;cursor:pointer;text-decoration:none;display:inline-block;text-align:center}
.btn.primary{border-color:#4c2dbd;background:linear-gradient(135deg,#ffd54d,#ffe082);color:#0a1222;font-weight:900;box-shadow:0 12px 30px #ffd54d44}
</style>
</head>
<body>
<div class="wrap">
  <h1>
    <span><?php echo $id?'Editar Prêmio':'Novo Prêmio'; ?></span>
    <span style="display:flex;flex-wrap:wrap;gap:10px">
      <a class="btn" href="prizes.php">← Voltar</a>
    </span>
  </h1>

  <div class="card">
    <form method="post">
      <label>Nome do prêmio</label>
      <input type="text" name="label" value="<?php echo htmlspecialchars($label); ?>" required>

      <div class="rowflex">
        <div>
          <label>Cor</label>
          <input type="color" name="color" value="<?php echo htmlspecialchars($color); ?>">
        </div>
        <div>
          <label>Peso (chance relativa)</label>
          <input type="number" name="weight" min="0" step="0.1" value="<?php echo htmlspecialchars($weight); ?>">
        </div>
      </div>

      <div>
        <label>Pontos ganhos</label>
        <input type="number" name="reward_points" min="0" step="1" value="<?php echo htmlspecialchars($reward); ?>">
      </div>

      <div class="err"><?php echo htmlspecialchars($err); ?></div>

      <button class="btn primary" type="submit">Salvar</button>
    </form>
  </div>
</div>
</body>
</html>
