<?php
require_once __DIR__.'/../config.php';
require_login();
require_admin();

$prStmt = $pdo->query("SELECT id,sort_order,label,color,weight,reward_points FROM prizes ORDER BY sort_order ASC, id ASC");
$prizes = $prStmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width,initial-scale=1" />
<title>Prêmios • Admin</title>
<meta name="color-scheme" content="dark" />
<style>
body{margin:0;background:#0b1220;color:#f8fafc;font-family:Inter,system-ui}
.wrap{max-width:1100px;margin:24px auto;padding:16px}
h1{margin:0 0 16px;font-size:20px;font-weight:700;color:#fff;display:flex;justify-content:space-between;flex-wrap:wrap;gap:10px}
.btn{border-radius:10px;border:1px solid #243357;background:#0b142b;color:#e5e7eb;padding:10px 12px;cursor:pointer;font-size:14px;text-decoration:none;display:inline-flex;align-items:center;gap:6px}
.btn.primary{border-color:#4c2dbd;background:linear-gradient(135deg,#ffd54d,#ffe082);color:#0a1222;font-weight:900;box-shadow:0 12px 30px #ffd54d44}
.tableWrap{background:#0e1729;border:1px solid #1e2948;border-radius:16px;box-shadow:0 24px 80px #000a;overflow:hidden}
.headRow,.row{display:grid;grid-template-columns:60px minmax(200px,1fr) 100px 90px 90px 90px;align-items:center}
.headRow{background:#0d1731;color:#cbd5e1;font-size:12px;font-weight:600}
.cell{padding:12px;border-top:1px solid #1c2a44;font-size:14px;color:#fff;min-height:48px;display:flex;align-items:center;gap:8px}
.row:nth-child(even){background:#0f1831}
.dragHandle{cursor:grab;font-size:16px;line-height:1;color:#94a3b8}
.colorDot{width:14px;height:14px;border-radius:999px;box-shadow:0 0 0 2px #0b1220,0 0 0 3px #1c2a4d}
.actions{display:flex;flex-wrap:wrap;gap:8px}
a.actionLink{color:#e5e7eb;text-decoration:none;border:1px solid #243357;background:#0b142b;border-radius:8px;padding:6px 8px;font-size:12px;line-height:1}
a.actionDanger{border-color:#5b2333;background:#2a0f14;color:#ffd2d2}
.note{font-size:12px;color:#9aa4b2;margin-top:16px}
</style>
</head>
<body>
<div class="wrap">
  <h1>
    <span>Prêmios da Roleta</span>
    <span style="display:flex;flex-wrap:wrap;gap:10px">
      <a class="btn" href="index.php">← Voltar</a>
      <a class="btn primary" href="prize_edit.php">+ Novo prêmio</a>
    </span>
  </h1>

  <div class="tableWrap">
    <div class="headRow">
      <div class="cell" style="border-top:0">Ordem</div>
      <div class="cell" style="border-top:0">Prêmio</div>
      <div class="cell" style="border-top:0">Cor</div>
      <div class="cell" style="border-top:0">Peso</div>
      <div class="cell" style="border-top:0">Pontos</div>
      <div class="cell" style="border-top:0">Ações</div>
    </div>
    <div id="rows">
      <?php foreach($prizes as $p): ?>
      <div class="row" data-id="<?php echo $p['id']; ?>">
        <div class="cell"><span class="dragHandle">⋮⋮</span> #<?php echo (int)$p['sort_order']; ?></div>
        <div class="cell"><?php echo htmlspecialchars($p['label']); ?></div>
        <div class="cell"><span class="colorDot" style="background:<?php echo htmlspecialchars($p['color']); ?>"></span> <span><?php echo htmlspecialchars($p['color']); ?></span></div>
        <div class="cell"><?php echo (float)$p['weight']; ?></div>
        <div class="cell"><?php echo (int)$p['reward_points']; ?> pts</div>
        <div class="cell">
          <div class="actions">
            <a class="actionLink" href="prize_edit.php?id=<?php echo $p['id']; ?>">Editar</a>
            <a class="actionLink actionDanger" href="prize_delete.php?id=<?php echo $p['id']; ?>" onclick="return confirm('Apagar este prêmio?')">Apagar</a>
          </div>
        </div>
      </div>
      <?php endforeach; ?>
    </div>
  </div>

  <div class="note">Arraste as linhas para reordenar. A ordem define a posição na roleta.</div>
</div>

<script>
const rows = document.getElementById('rows');
let dragging=null;

rows.addEventListener('dragstart',e=>{
  const row=e.target.closest('.row');
  if(!row)return;
  dragging=row;
  row.style.opacity='0.4';
});
rows.addEventListener('dragend',e=>{
  if(!dragging)return;
  dragging.style.opacity='';
  sendOrder();
  dragging=null;
});
rows.addEventListener('dragover',e=>{
  e.preventDefault();
  const after=getAfter(e.clientY);
  if(!dragging)return;
  if(after==null){rows.appendChild(dragging);}
  else{rows.insertBefore(dragging,after);}
});

function getAfter(y){
  const els=[...rows.querySelectorAll('.row:not([style*="opacity"])')];
  let closest={off:-Infinity,el:null};
  els.forEach(el=>{
    const box=el.getBoundingClientRect();
    const offset=y-box.top-box.height/2;
    if(offset<0 && offset>closest.off){closest={off:offset,el:el};}
  });
  return closest.el;
}

function sendOrder(){
  const order=[...rows.children].map((row,i)=>({id:row.dataset.id,sort_order:i+1}));
  fetch('prizes_sort.php',{
    method:'POST',
    headers:{'Content-Type':'application/json'},
    body:JSON.stringify(order)
  });
}

[...rows.children].forEach(r=>r.setAttribute('draggable','true'));
</script>
</body>
</html>
