<?php
require_once __DIR__.'/config.php';
require_login();
header('Content-Type: application/json; charset=utf-8');

$user = current_user($pdo);
if(!$user){ echo json_encode(['error'=>'auth']); exit; }

$cfgStmt = $pdo->query("SELECT lock_hours FROM wheel_config WHERE id=1");
$cfg = $cfgStmt->fetch();
$lock_hours = $cfg ? (int)$cfg['lock_hours'] : 24;

if ($user['ultimo_giro']) {
    $last = strtotime($user['ultimo_giro']);
    $next = $last + $lock_hours*3600;
    if (time() < $next) {
        $left = $next - time();
        $h = floor($left/3600);
        $m = floor(($left%3600)/60);
        $s = $left%60;
        echo json_encode([
            'error'=>'locked',
            'remaining'=>sprintf('%02d:%02d:%02d',$h,$m,$s)
        ]);
        exit;
    }
}

$stp = $pdo->query("SELECT id,label,color,weight,reward_points FROM prizes ORDER BY sort_order ASC");
$all = $stp->fetchAll();
if(!$all){ echo json_encode(['error'=>'no_prizes']); exit; }

$weights = array_map(fn($p)=>floatval($p['weight']?:1), $all);
$sum = array_sum($weights);
$r = mt_rand() / mt_getrandmax() * $sum;
$chosen = null;
for($i=0;$i<count($all);$i++){
    $r -= $weights[$i];
    if($r<=0){ $chosen=$all[$i]; break; }
}
if(!$chosen){ $chosen = $all[count($all)-1]; }

$pdo->beginTransaction();
try {
    $stIns = $pdo->prepare("INSERT INTO spins (user_id,prize_id,pontos_ganhos) VALUES (?,?,?)");
    $stIns->execute([$user['id'],$chosen['id'],$chosen['reward_points']]);

    $stUp = $pdo->prepare("UPDATE users SET pontos_total = pontos_total + ?, ultimo_giro = NOW() WHERE id=?");
    $stUp->execute([$chosen['reward_points'],$user['id']]);

    $pdo->commit();
} catch(Exception $e){
    $pdo->rollBack();
    echo json_encode(['error'=>'db']);
    exit;
}

echo json_encode([
    'ok'=>true,
    'prize'=>[
        'label'=>$chosen['label'],
        'color'=>$chosen['color'],
        'points'=>(int)$chosen['reward_points']
    ],
    'new_total'=> (int)$user['pontos_total'] + (int)$chosen['reward_points']
], JSON_UNESCAPED_UNICODE);
